CREATE DATABASE guestbook_db;
USE guestbook_db;

CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'guest') DEFAULT 'guest',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE guests (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tanggal DATE NOT NULL,
    nama VARCHAR(100) NOT NULL,
    asal_instansi VARCHAR(100),
    perihal VARCHAR(255),
    no_hp VARCHAR(15),
    foto_tamu VARCHAR(255),
    tanda_tangan TEXT,
    user_id INT NULL,
    is_registered BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);

CREATE TABLE admin_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) NOT NULL UNIQUE,
    setting_value TEXT
);

INSERT INTO users (username, password, role) VALUES
('admin', '$2y$10$K7Q/jvJN0Y2Pj.PDh1ZgiOdO6cvjOI9J/SBB9nPZmX4tEKv4RCJdG', 'admin');

CREATE INDEX idx_user_id ON guests(user_id);
CREATE INDEX idx_tanggal ON guests(tanggal);
