<?php
require 'vendor/autoload.php';
include 'db_connection.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use TCPDF;

session_start();

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $type = $_GET['type'];
    
    $isRegistered = isset($_SESSION['user_id']) ? true : (isset($_SESSION['non_registered_guest_id']) && $_SESSION['non_registered_guest_id'] == $id);

    if ($isRegistered) {
        $sql = "SELECT * FROM guests WHERE id = '$id'";
        $result = $conn->query($sql);
        $data = $result->fetch_assoc();

        if ($type == 'pdf') {
            $pdf = new TCPDF();
            $pdf->AddPage();
            $html = "<h2>Data Kunjungan Tamu</h2>
                     <p>Nama: {$data['nama']}</p>
                     <p>Asal/Instansi: {$data['asal_instansi']}</p>
                     <p>Perihal: {$data['perihal']}</p>";
            $pdf->writeHTML($html, true, false, true, false, '');
            $pdf->Output("Kunjungan_Tamu_{$data['id']}.pdf", 'D');
        } elseif ($type == 'excel') {
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            $sheet->setCellValue('A1', 'Nama')->setCellValue('B1', $data['nama'])
                  ->setCellValue('A2', 'Asal/Instansi')->setCellValue('B2', $data['asal_instansi'])
                  ->setCellValue('A3', 'Perihal')->setCellValue('B3', $data['perihal']);
            $writer = new Xlsx($spreadsheet);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment; filename=Kunjungan_Tamu_{$data['id']}.xlsx");
            $writer->save("php://output");
        }
    } else {
        echo "Data tidak ditemukan.";
    }
}
?>
